# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_DANISH} "(Use CD)"
LangString ReadOnly ${LANG_DANISH} "(Read Only)"
LangString MainHeaderSubText ${LANG_DANISH} "Vlg venligst brugernavn og kodeord til den nye konto"
LangString MainLanguageLabel ${LANG_DANISH} "Sprog:"
LangString MainUsernameLabel ${LANG_DANISH} "Brugernavn:"
LangString MainPasswordLabel ${LANG_DANISH} "Kodeord:"
LangString MainInstallationSizeLabel ${LANG_DANISH} "Installationens strrelse (GB):"
LangString MainDistroLabel ${LANG_DANISH} "Skrivebordsmilj:"
LangString MainInstallationDriveLabel ${LANG_DANISH} "Installationsstrrelse (GB):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_DANISH} "Ubuntu vil blive installeret i det valgte sprog."
LangString MainUsernameToolTip ${LANG_DANISH} "Dette vil blive dit brugernavn i Ubuntu.$\r$\nDet skal vre i sm bogstaver.$\r$\nDEt m ikke indeholde mellemrum.$\r$\nDet m kun indeholde standart bogstaver og tal.$\r$\nDet m ikke starte med et tal."
LangString MainPasswordToolTip ${LANG_DANISH} "Dette vil blive dit kodeord i Ubuntu.$\r$\nDet m ikke indeholde mellemrum."
LangString MainInstallationSizeToolTip ${LANG_DANISH} "Hvormange GB nsker du at blive allokeret til Ubuntu?$\r$\n4 GB er minimum $\r$\n8 GB er anbefalet"
LangString MainInstallationDriveToolTip ${LANG_DANISH} "P hvilet drev nsker du at installere Ubuntu?$\r$\nDette drev skal idealt have 10 GB fri."
LangString Distro1ToolTip ${LANG_DANISH} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_DANISH} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_DANISH} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_DANISH} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_DANISH} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_DANISH} "Indtast venligst et gyldigt brugernavn"
LangString ErrorSpaceInUsername ${LANG_DANISH} "Brug venligst ikke mellemrum i brugernavnet."
LangString ErrorUsernameUpperCase ${LANG_DANISH} "Brug venligst kun sm bogstaver i brugernavnet."
LangString ErrorUsernameFirstCharNotLetter ${LANG_DANISH} "Dit brugernavn skal starte med et bogstav."
LangString ErrorUsernameIllegalChars ${LANG_DANISH} "Dit brugernavn m kun best af bogstaver og tal."
LangString ErrorReservedUsername ${LANG_DANISH} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_DANISH} "Indtast venligst et gyldigt kodeord."
LangString ErrorPasswordMismatch ${LANG_DANISH} "Kodeorderne er ikke ens."
LangString ErrorSpaceInPassword ${LANG_DANISH} "Brug venligst ikke mellemrum i kodeordet."
LangString ErrorNoFreeSpace ${LANG_DANISH} "Der er ikke nok fri plads. Der behves mindst 4 GB."
LangString ErrorNoKernel ${LANG_DANISH} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_DANISH} "Fejl ved forsg af eksekvering:"
LangString ErrorWubibcd ${LANG_DANISH} "Fejl ved forsg af eksekvering:"
LangString ErrorCD2ISO ${LANG_DANISH} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_DANISH} "Hentningen blev afbrudt med fejlen:"
LangString ErrorNoCD ${LANG_DANISH} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_DANISH} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_DANISH} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_DANISH} "Du er p vej til at installere"
LangString InstallHeaderInitializing ${LANG_DANISH} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_DANISH} "Vent venligst mens de pkrvede filer bliver hentet og forberedt"
LangString InstallHeaderUncompressWubifolder ${LANG_DANISH} "Udpakker wubi mappen..."
LangString InstallHeaderCopyIso ${LANG_DANISH} "Kopierer installationsfiler..."
LangString InstallHeaderDownload ${LANG_DANISH} "Henter installationsfiler, genoptagelse er muligt"
LangString InstallHeaderBackupIso ${LANG_DANISH} "Sikkerhedskopierer installationsfiler..."
LangString InstallHeaderWritePreseed ${LANG_DANISH} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_DANISH} "Konfigurerer afinstallationsprogram..."
LangString InstallHeaderWriteBootLoader ${LANG_DANISH} "Konfigurerer opstartsprogram..."
LangString InstallGenerateVirtualDisks ${LANG_DANISH} "Opretter virtuelle diske..."
LangString InstallCopyFiles ${LANG_DANISH} "Kopierer installationsfiler..."
LangString InstallCreateFolders ${LANG_DANISH} "Skaber virtuelle drev..."
LangString InstallRetrieveIso ${LANG_DANISH} "Downloader %s"

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_DANISH} "er allerede installeret"
LangString UninstallAsk ${LANG_DANISH} "Hvad nsker du at gre?"
LangString UninstallMessageField ${LANG_DANISH} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_DANISH} "Sikkerhedskopiere hentet filer. (CD iso fil)"
LangString UninstallBackupHomeCheckBox ${LANG_DANISH} "Sikkerhedskopiere Ubuntu dokumenter (home.virtual.disk)"
LangString UninstallBackupLocationField ${LANG_DANISH} "Sted for sikkerhedskopier:"

# FINISH
LangString EjectRebootMsg ${LANG_DANISH} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_DANISH} "Du bliver ndt til at genstarte computeren, for at fuldfre installationen."

# DOWNLOADER
LangString MetadlDownloading ${LANG_DANISH} "Kopier installationsfilerne..."
LangString MetadlChecking ${LANG_DANISH} "Sikkerhedskopierer installationsfilerne..."
LangString MetadlConnecting ${LANG_DANISH} "Forbinder til %s..."
LangString MetadlInitializing ${LANG_DANISH} "Initialiser download..."
LangString MetadlChecksums ${LANG_DANISH} "Udregner kontrolsumme..."
LangString MetadlRetrying1 ${LANG_DANISH} "Forsger igen om %d sekunder... (%d ud af %d)"
LangString MetadlRetrying2 ${LANG_DANISH} "Forsger igen om %d sekunder..."
LangString MetadlSecond ${LANG_DANISH} "sekund"
LangString MetadlSeconds ${LANG_DANISH} "sekunder"
LangString MetadlProgress ${LANG_DANISH} "%s (%d%%) ud af %s @ %s/s"
LangString MetadlRemaining ${LANG_DANISH} " (%s tilbage)"
LangString PleaseConnect ${LANG_DANISH} "Forbind venligst til internettet nu."

# ACCESSIBILITY
LangString MobilityAids ${LANG_DANISH} "Mobility Aids"
LangString VisibilityAids ${LANG_DANISH} "Visibility Aids"
LangString AccessibilityButton ${LANG_DANISH} "&Accessibility"
LangString AccessibilityText ${LANG_DANISH} "Accessibility profile"
LangString AccessibilitySubText ${LANG_DANISH} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_DANISH} "None"
LangString VisibilityHighContrast ${LANG_DANISH} "High Contrast"
LangString VisibilityMagnifier ${LANG_DANISH} "Magnifier"
LangString VisibilityScreenReader ${LANG_DANISH} "Screen Reader"
LangString VisibilityBraille ${LANG_DANISH} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_DANISH} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_DANISH} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_DANISH} "Install CD booter"
LangString CDBootText ${LANG_DANISH} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_DANISH} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_DANISH} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_DANISH} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_DANISH} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_DANISH} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
